/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.public_download_count_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsPaginatedContentDownloaderResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicListContentDownloaderV2
extends Operation {
    private String path = "/ugc/v2/public/namespaces/{namespace}/contents/{contentId}/downloader";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json", "application/octet-stream");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String contentId;
    private String namespace;
    private Integer limit;
    private Integer offset;
    private String sortBy;
    private String userId;

    @Deprecated
    public PublicListContentDownloaderV2(String contentId, String namespace, Integer limit, Integer offset, String sortBy, String userId) {
        this.contentId = contentId;
        this.namespace = namespace;
        this.limit = limit;
        this.offset = offset;
        this.sortBy = sortBy;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.contentId != null) {
            pathParams.put("contentId", this.contentId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        queryParams.put("userId", this.userId == null ? null : Arrays.asList(this.userId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.contentId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsPaginatedContentDownloaderResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPaginatedContentDownloaderResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("sortBy", "None");
        result.put("userId", "None");
        return result;
    }

    public static PublicListContentDownloaderV2Builder builder() {
        return new PublicListContentDownloaderV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class PublicListContentDownloaderV2Builder {
        private String contentId;
        private String namespace;
        private Integer limit;
        private Integer offset;
        private String sortBy;
        private String userId;

        PublicListContentDownloaderV2Builder() {
        }

        public PublicListContentDownloaderV2Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public PublicListContentDownloaderV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicListContentDownloaderV2Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicListContentDownloaderV2Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicListContentDownloaderV2Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public PublicListContentDownloaderV2Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicListContentDownloaderV2 build() {
            return new PublicListContentDownloaderV2(this.contentId, this.namespace, this.limit, this.offset, this.sortBy, this.userId);
        }

        public String toString() {
            return "PublicListContentDownloaderV2.PublicListContentDownloaderV2Builder(contentId=" + this.contentId + ", namespace=" + this.namespace + ", limit=" + this.limit + ", offset=" + this.offset + ", sortBy=" + this.sortBy + ", userId=" + this.userId + ")";
        }
    }
}

