/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.public_content_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsPaginatedContentDownloadResponseV2;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetContentByUserIDV2
extends Operation {
    private String path = "/ugc/v2/public/namespaces/{namespace}/users/{userId}/contents";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json", "application/octet-stream");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private Integer limit;
    private Integer offset;
    private String sortBy;

    @Deprecated
    public PublicGetContentByUserIDV2(String namespace, String userId, Integer limit, Integer offset, String sortBy) {
        this.namespace = namespace;
        this.userId = userId;
        this.limit = limit;
        this.offset = offset;
        this.sortBy = sortBy;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelsPaginatedContentDownloadResponseV2 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPaginatedContentDownloadResponseV2().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("sortBy", "None");
        return result;
    }

    public static PublicGetContentByUserIDV2Builder builder() {
        return new PublicGetContentByUserIDV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public static class PublicGetContentByUserIDV2Builder {
        private String namespace;
        private String userId;
        private Integer limit;
        private Integer offset;
        private String sortBy;

        PublicGetContentByUserIDV2Builder() {
        }

        public PublicGetContentByUserIDV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetContentByUserIDV2Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicGetContentByUserIDV2Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicGetContentByUserIDV2Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicGetContentByUserIDV2Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public PublicGetContentByUserIDV2 build() {
            return new PublicGetContentByUserIDV2(this.namespace, this.userId, this.limit, this.offset, this.sortBy);
        }

        public String toString() {
            return "PublicGetContentByUserIDV2.PublicGetContentByUserIDV2Builder(namespace=" + this.namespace + ", userId=" + this.userId + ", limit=" + this.limit + ", offset=" + this.offset + ", sortBy=" + this.sortBy + ")";
        }
    }
}

