/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.public_content_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DeleteContentScreenshotV2
extends Operation {
    private String path = "/ugc/v2/public/namespaces/{namespace}/users/{userId}/contents/{contentId}/screenshots/{screenshotId}";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList("application/json", "application/octet-stream");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String contentId;
    private String namespace;
    private String screenshotId;
    private String userId;

    @Deprecated
    public DeleteContentScreenshotV2(String contentId, String namespace, String screenshotId, String userId) {
        this.contentId = contentId;
        this.namespace = namespace;
        this.screenshotId = screenshotId;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.contentId != null) {
            pathParams.put("contentId", this.contentId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.screenshotId != null) {
            pathParams.put("screenshotId", this.screenshotId);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.contentId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        if (this.screenshotId == null) {
            return false;
        }
        return this.userId != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static DeleteContentScreenshotV2Builder builder() {
        return new DeleteContentScreenshotV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getScreenshotId() {
        return this.screenshotId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setScreenshotId(String screenshotId) {
        this.screenshotId = screenshotId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class DeleteContentScreenshotV2Builder {
        private String contentId;
        private String namespace;
        private String screenshotId;
        private String userId;

        DeleteContentScreenshotV2Builder() {
        }

        public DeleteContentScreenshotV2Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public DeleteContentScreenshotV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DeleteContentScreenshotV2Builder screenshotId(String screenshotId) {
            this.screenshotId = screenshotId;
            return this;
        }

        public DeleteContentScreenshotV2Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public DeleteContentScreenshotV2 build() {
            return new DeleteContentScreenshotV2(this.contentId, this.namespace, this.screenshotId, this.userId);
        }

        public String toString() {
            return "DeleteContentScreenshotV2.DeleteContentScreenshotV2Builder(contentId=" + this.contentId + ", namespace=" + this.namespace + ", screenshotId=" + this.screenshotId + ", userId=" + this.userId + ")";
        }
    }
}

