/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.public_channel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsChannelResponse;
import net.accelbyte.sdk.api.ugc.models.ModelsUpdateChannelRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateChannel
extends Operation {
    private String path = "/ugc/v1/public/namespaces/{namespace}/users/{userId}/channels/{channelId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json", "application/octet-stream");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String channelId;
    private String namespace;
    private String userId;
    private ModelsUpdateChannelRequest body;

    @Deprecated
    public UpdateChannel(String channelId, String namespace, String userId, ModelsUpdateChannelRequest body) {
        this.channelId = channelId;
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.channelId != null) {
            pathParams.put("channelId", this.channelId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public ModelsUpdateChannelRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.channelId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelsChannelResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsChannelResponse().createFromJson(json);
    }

    public static UpdateChannelBuilder builder() {
        return new UpdateChannelBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public ModelsUpdateChannelRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(ModelsUpdateChannelRequest body) {
        this.body = body;
    }

    public static class UpdateChannelBuilder {
        private String channelId;
        private String namespace;
        private String userId;
        private ModelsUpdateChannelRequest body;

        UpdateChannelBuilder() {
        }

        public UpdateChannelBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public UpdateChannelBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateChannelBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public UpdateChannelBuilder body(ModelsUpdateChannelRequest body) {
            this.body = body;
            return this;
        }

        public UpdateChannel build() {
            return new UpdateChannel(this.channelId, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "UpdateChannel.UpdateChannelBuilder(channelId=" + this.channelId + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

