/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_staging_content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsApproveStagingContentRequest;
import net.accelbyte.sdk.api.ugc.models.ModelsStagingContentResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminApproveStagingContent
extends Operation {
    private String path = "/ugc/v2/admin/namespaces/{namespace}/staging-contents/{contentId}/approve";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String contentId;
    private String namespace;
    private ModelsApproveStagingContentRequest body;

    @Deprecated
    public AdminApproveStagingContent(String contentId, String namespace, ModelsApproveStagingContentRequest body) {
        this.contentId = contentId;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.contentId != null) {
            pathParams.put("contentId", this.contentId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ModelsApproveStagingContentRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.contentId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsStagingContentResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsStagingContentResponse().createFromJson(json);
    }

    public static AdminApproveStagingContentBuilder builder() {
        return new AdminApproveStagingContentBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ModelsApproveStagingContentRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ModelsApproveStagingContentRequest body) {
        this.body = body;
    }

    public static class AdminApproveStagingContentBuilder {
        private String contentId;
        private String namespace;
        private ModelsApproveStagingContentRequest body;

        AdminApproveStagingContentBuilder() {
        }

        public AdminApproveStagingContentBuilder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public AdminApproveStagingContentBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminApproveStagingContentBuilder body(ModelsApproveStagingContentRequest body) {
            this.body = body;
            return this;
        }

        public AdminApproveStagingContent build() {
            return new AdminApproveStagingContent(this.contentId, this.namespace, this.body);
        }

        public String toString() {
            return "AdminApproveStagingContent.AdminApproveStagingContentBuilder(contentId=" + this.contentId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

