/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_content_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsAdminUpdateContentRequestV2;
import net.accelbyte.sdk.api.ugc.models.ModelsUpdateContentResponseV2;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminUpdateUserContentV2
extends Operation {
    private String path = "/ugc/v2/admin/namespaces/{namespace}/users/{userId}/channels/{channelId}/contents/{contentId}";
    private String method = "PATCH";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String channelId;
    private String contentId;
    private String namespace;
    private String userId;
    private ModelsAdminUpdateContentRequestV2 body;

    @Deprecated
    public AdminUpdateUserContentV2(String channelId, String contentId, String namespace, String userId, ModelsAdminUpdateContentRequestV2 body) {
        this.channelId = channelId;
        this.contentId = contentId;
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.channelId != null) {
            pathParams.put("channelId", this.channelId);
        }
        if (this.contentId != null) {
            pathParams.put("contentId", this.contentId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public ModelsAdminUpdateContentRequestV2 getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.channelId == null) {
            return false;
        }
        if (this.contentId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelsUpdateContentResponseV2 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsUpdateContentResponseV2().createFromJson(json);
    }

    public static AdminUpdateUserContentV2Builder builder() {
        return new AdminUpdateUserContentV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public ModelsAdminUpdateContentRequestV2 getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(ModelsAdminUpdateContentRequestV2 body) {
        this.body = body;
    }

    public static class AdminUpdateUserContentV2Builder {
        private String channelId;
        private String contentId;
        private String namespace;
        private String userId;
        private ModelsAdminUpdateContentRequestV2 body;

        AdminUpdateUserContentV2Builder() {
        }

        public AdminUpdateUserContentV2Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public AdminUpdateUserContentV2Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public AdminUpdateUserContentV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminUpdateUserContentV2Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminUpdateUserContentV2Builder body(ModelsAdminUpdateContentRequestV2 body) {
            this.body = body;
            return this;
        }

        public AdminUpdateUserContentV2 build() {
            return new AdminUpdateUserContentV2(this.channelId, this.contentId, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "AdminUpdateUserContentV2.AdminUpdateUserContentV2Builder(channelId=" + this.channelId + ", contentId=" + this.contentId + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

