/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_content_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsContentDownloadResponseV2;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetContentByContentIDV2
extends Operation {
    private String path = "/ugc/v2/admin/namespaces/{namespace}/contents/{contentId}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String contentId;
    private String namespace;

    @Deprecated
    public AdminGetContentByContentIDV2(String contentId, String namespace) {
        this.contentId = contentId;
        this.namespace = namespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.contentId != null) {
            pathParams.put("contentId", this.contentId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.contentId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsContentDownloadResponseV2 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsContentDownloadResponseV2().createFromJson(json);
    }

    public static AdminGetContentByContentIDV2Builder builder() {
        return new AdminGetContentByContentIDV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class AdminGetContentByContentIDV2Builder {
        private String contentId;
        private String namespace;

        AdminGetContentByContentIDV2Builder() {
        }

        public AdminGetContentByContentIDV2Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public AdminGetContentByContentIDV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetContentByContentIDV2 build() {
            return new AdminGetContentByContentIDV2(this.contentId, this.namespace);
        }

        public String toString() {
            return "AdminGetContentByContentIDV2.AdminGetContentByContentIDV2Builder(contentId=" + this.contentId + ", namespace=" + this.namespace + ")";
        }
    }
}

