/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_content_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsAdminContentRequestV2;
import net.accelbyte.sdk.api.ugc.models.ModelsCreateContentResponseV2;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminCreateContentV2
extends Operation {
    private String path = "/ugc/v2/admin/namespaces/{namespace}/channels/{channelId}/contents";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String channelId;
    private String namespace;
    private ModelsAdminContentRequestV2 body;

    @Deprecated
    public AdminCreateContentV2(String channelId, String namespace, ModelsAdminContentRequestV2 body) {
        this.channelId = channelId;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.channelId != null) {
            pathParams.put("channelId", this.channelId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ModelsAdminContentRequestV2 getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.channelId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsCreateContentResponseV2 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 201) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsCreateContentResponseV2().createFromJson(json);
    }

    public static AdminCreateContentV2Builder builder() {
        return new AdminCreateContentV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ModelsAdminContentRequestV2 getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ModelsAdminContentRequestV2 body) {
        this.body = body;
    }

    public static class AdminCreateContentV2Builder {
        private String channelId;
        private String namespace;
        private ModelsAdminContentRequestV2 body;

        AdminCreateContentV2Builder() {
        }

        public AdminCreateContentV2Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public AdminCreateContentV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminCreateContentV2Builder body(ModelsAdminContentRequestV2 body) {
            this.body = body;
            return this;
        }

        public AdminCreateContentV2 build() {
            return new AdminCreateContentV2(this.channelId, this.namespace, this.body);
        }

        public String toString() {
            return "AdminCreateContentV2.AdminCreateContentV2Builder(channelId=" + this.channelId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

