/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DeleteContentByShareCode
extends Operation {
    private String path = "/ugc/v1/admin/namespaces/{namespace}/users/{userId}/channels/{channelId}/contents/sharecodes/{shareCode}";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String channelId;
    private String namespace;
    private String shareCode;
    private String userId;

    @Deprecated
    public DeleteContentByShareCode(String channelId, String namespace, String shareCode, String userId) {
        this.channelId = channelId;
        this.namespace = namespace;
        this.shareCode = shareCode;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.channelId != null) {
            pathParams.put("channelId", this.channelId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.shareCode != null) {
            pathParams.put("shareCode", this.shareCode);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.channelId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        if (this.shareCode == null) {
            return false;
        }
        return this.userId != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static DeleteContentByShareCodeBuilder builder() {
        return new DeleteContentByShareCodeBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getShareCode() {
        return this.shareCode;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setShareCode(String shareCode) {
        this.shareCode = shareCode;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class DeleteContentByShareCodeBuilder {
        private String channelId;
        private String namespace;
        private String shareCode;
        private String userId;

        DeleteContentByShareCodeBuilder() {
        }

        public DeleteContentByShareCodeBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public DeleteContentByShareCodeBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DeleteContentByShareCodeBuilder shareCode(String shareCode) {
            this.shareCode = shareCode;
            return this;
        }

        public DeleteContentByShareCodeBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public DeleteContentByShareCode build() {
            return new DeleteContentByShareCode(this.channelId, this.namespace, this.shareCode, this.userId);
        }

        public String toString() {
            return "DeleteContentByShareCode.DeleteContentByShareCodeBuilder(channelId=" + this.channelId + ", namespace=" + this.namespace + ", shareCode=" + this.shareCode + ", userId=" + this.userId + ")";
        }
    }
}

