/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.public_creator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsPaginatedCreatorOverviewResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicSearchCreator
extends Operation {
    private String path = "/ugc/v1/public/namespaces/{namespace}/users";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json", "application/octet-stream");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Integer limit;
    private Integer offset;
    private String orderby;
    private String sortby;

    @Deprecated
    public PublicSearchCreator(String namespace, Integer limit, Integer offset, String orderby, String sortby) {
        this.namespace = namespace;
        this.limit = limit;
        this.offset = offset;
        this.orderby = orderby;
        this.sortby = sortby;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("orderby", this.orderby == null ? null : Arrays.asList(this.orderby));
        queryParams.put("sortby", this.sortby == null ? null : Arrays.asList(this.sortby));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelsPaginatedCreatorOverviewResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPaginatedCreatorOverviewResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("orderby", "None");
        result.put("sortby", "None");
        return result;
    }

    public static PublicSearchCreatorBuilder builder() {
        return new PublicSearchCreatorBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getOrderby() {
        return this.orderby;
    }

    public String getSortby() {
        return this.sortby;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setOrderby(String orderby) {
        this.orderby = orderby;
    }

    public void setSortby(String sortby) {
        this.sortby = sortby;
    }

    public static class PublicSearchCreatorBuilder {
        private String namespace;
        private Integer limit;
        private Integer offset;
        private String orderby;
        private String sortby;

        PublicSearchCreatorBuilder() {
        }

        public PublicSearchCreatorBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicSearchCreatorBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicSearchCreatorBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicSearchCreatorBuilder orderby(String orderby) {
            this.orderby = orderby;
            return this;
        }

        public PublicSearchCreatorBuilder sortby(String sortby) {
            this.sortby = sortby;
            return this;
        }

        public PublicSearchCreator build() {
            return new PublicSearchCreator(this.namespace, this.limit, this.offset, this.orderby, this.sortby);
        }

        public String toString() {
            return "PublicSearchCreator.PublicSearchCreatorBuilder(namespace=" + this.namespace + ", limit=" + this.limit + ", offset=" + this.offset + ", orderby=" + this.orderby + ", sortby=" + this.sortby + ")";
        }
    }
}

