/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.public_content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsContentDownloadResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicDownloadContentByShareCode
extends Operation {
    private String path = "/ugc/v1/public/namespaces/{namespace}/contents/sharecodes/{shareCode}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json", "application/octet-stream");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String shareCode;

    @Deprecated
    public PublicDownloadContentByShareCode(String namespace, String shareCode) {
        this.namespace = namespace;
        this.shareCode = shareCode;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.shareCode != null) {
            pathParams.put("shareCode", this.shareCode);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.shareCode != null;
    }

    public ModelsContentDownloadResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsContentDownloadResponse().createFromJson(json);
    }

    public static PublicDownloadContentByShareCodeBuilder builder() {
        return new PublicDownloadContentByShareCodeBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getShareCode() {
        return this.shareCode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setShareCode(String shareCode) {
        this.shareCode = shareCode;
    }

    public static class PublicDownloadContentByShareCodeBuilder {
        private String namespace;
        private String shareCode;

        PublicDownloadContentByShareCodeBuilder() {
        }

        public PublicDownloadContentByShareCodeBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicDownloadContentByShareCodeBuilder shareCode(String shareCode) {
            this.shareCode = shareCode;
            return this;
        }

        public PublicDownloadContentByShareCode build() {
            return new PublicDownloadContentByShareCode(this.namespace, this.shareCode);
        }

        public String toString() {
            return "PublicDownloadContentByShareCode.PublicDownloadContentByShareCodeBuilder(namespace=" + this.namespace + ", shareCode=" + this.shareCode + ")";
        }
    }
}

