/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.sessionhistory.operations.x_ray;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.sessionhistory.models.ApimodelsXRayMatchHistorQueryResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryMatchHistories
extends Operation {
    private String path = "/sessionhistory/v2/admin/namespaces/{namespace}/xray/matches/{matchId}/histories";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String matchId;
    private String namespace;
    private Integer limit;
    private Integer offset;

    @Deprecated
    public QueryMatchHistories(String matchId, String namespace, Integer limit, Integer offset) {
        this.matchId = matchId;
        this.namespace = namespace;
        this.limit = limit;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.matchId != null) {
            pathParams.put("matchId", this.matchId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.matchId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ApimodelsXRayMatchHistorQueryResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApimodelsXRayMatchHistorQueryResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        return result;
    }

    public static QueryMatchHistoriesBuilder builder() {
        return new QueryMatchHistoriesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getMatchId() {
        return this.matchId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setMatchId(String matchId) {
        this.matchId = matchId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class QueryMatchHistoriesBuilder {
        private String matchId;
        private String namespace;
        private Integer limit;
        private Integer offset;

        QueryMatchHistoriesBuilder() {
        }

        public QueryMatchHistoriesBuilder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public QueryMatchHistoriesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryMatchHistoriesBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryMatchHistoriesBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryMatchHistories build() {
            return new QueryMatchHistories(this.matchId, this.namespace, this.limit, this.offset);
        }

        public String toString() {
            return "QueryMatchHistories.QueryMatchHistoriesBuilder(matchId=" + this.matchId + ", namespace=" + this.namespace + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }
}

