/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.sessionbrowser.operations.session;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.sessionbrowser.models.ModelsRecentPlayerQueryResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetRecentPlayer
extends Operation {
    private String path = "/sessionbrowser/namespaces/{namespace}/recentplayer/{userID}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userID;

    @Deprecated
    public GetRecentPlayer(String namespace, String userID) {
        this.namespace = namespace;
        this.userID = userID;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userID != null) {
            pathParams.put("userID", this.userID);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userID != null;
    }

    public ModelsRecentPlayerQueryResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsRecentPlayerQueryResponse().createFromJson(json);
    }

    public static GetRecentPlayerBuilder builder() {
        return new GetRecentPlayerBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public static class GetRecentPlayerBuilder {
        private String namespace;
        private String userID;

        GetRecentPlayerBuilder() {
        }

        public GetRecentPlayerBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetRecentPlayerBuilder userID(String userID) {
            this.userID = userID;
            return this;
        }

        public GetRecentPlayer build() {
            return new GetRecentPlayer(this.namespace, this.userID);
        }

        public String toString() {
            return "GetRecentPlayer.GetRecentPlayerBuilder(namespace=" + this.namespace + ", userID=" + this.userID + ")";
        }
    }
}

