/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.sessionbrowser.operations.session;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.sessionbrowser.models.ModelsGetSessionHistorySearchResponseV2;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminSearchSessionsV2
extends Operation {
    private String path = "/sessionbrowser/admin/namespaces/{namespace}/sessions/history/search";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String channel;
    private Boolean deleted;
    private String matchID;
    private String partyID;
    private String sessionType;
    private String status;
    private String userID;
    private Integer limit;
    private Integer offset;

    @Deprecated
    public AdminSearchSessionsV2(String namespace, String channel, Boolean deleted, String matchID, String partyID, String sessionType, String status, String userID, Integer limit, Integer offset) {
        this.namespace = namespace;
        this.channel = channel;
        this.deleted = deleted;
        this.matchID = matchID;
        this.partyID = partyID;
        this.sessionType = sessionType;
        this.status = status;
        this.userID = userID;
        this.limit = limit;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("channel", this.channel == null ? null : Arrays.asList(this.channel));
        queryParams.put("deleted", this.deleted == null ? null : Arrays.asList(String.valueOf(this.deleted)));
        queryParams.put("matchID", this.matchID == null ? null : Arrays.asList(this.matchID));
        queryParams.put("partyID", this.partyID == null ? null : Arrays.asList(this.partyID));
        queryParams.put("sessionType", this.sessionType == null ? null : Arrays.asList(this.sessionType));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        queryParams.put("userID", this.userID == null ? null : Arrays.asList(this.userID));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.limit == null) {
            return false;
        }
        return this.offset != null;
    }

    public ModelsGetSessionHistorySearchResponseV2 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsGetSessionHistorySearchResponseV2().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("channel", "None");
        result.put("deleted", "None");
        result.put("matchID", "None");
        result.put("partyID", "None");
        result.put("sessionType", "None");
        result.put("status", "None");
        result.put("userID", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        return result;
    }

    public static AdminSearchSessionsV2Builder builder() {
        return new AdminSearchSessionsV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getChannel() {
        return this.channel;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public String getMatchID() {
        return this.matchID;
    }

    public String getPartyID() {
        return this.partyID;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public String getStatus() {
        return this.status;
    }

    public String getUserID() {
        return this.userID;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public void setMatchID(String matchID) {
        this.matchID = matchID;
    }

    public void setPartyID(String partyID) {
        this.partyID = partyID;
    }

    public void setSessionType(String sessionType) {
        this.sessionType = sessionType;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class AdminSearchSessionsV2Builder {
        private String namespace;
        private String channel;
        private Boolean deleted;
        private String matchID;
        private String partyID;
        private String sessionType;
        private String status;
        private String userID;
        private Integer limit;
        private Integer offset;

        AdminSearchSessionsV2Builder() {
        }

        public AdminSearchSessionsV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminSearchSessionsV2Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public AdminSearchSessionsV2Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public AdminSearchSessionsV2Builder matchID(String matchID) {
            this.matchID = matchID;
            return this;
        }

        public AdminSearchSessionsV2Builder partyID(String partyID) {
            this.partyID = partyID;
            return this;
        }

        public AdminSearchSessionsV2Builder sessionType(String sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public AdminSearchSessionsV2Builder status(String status) {
            this.status = status;
            return this;
        }

        public AdminSearchSessionsV2Builder userID(String userID) {
            this.userID = userID;
            return this;
        }

        public AdminSearchSessionsV2Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminSearchSessionsV2Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminSearchSessionsV2 build() {
            return new AdminSearchSessionsV2(this.namespace, this.channel, this.deleted, this.matchID, this.partyID, this.sessionType, this.status, this.userID, this.limit, this.offset);
        }

        public String toString() {
            return "AdminSearchSessionsV2.AdminSearchSessionsV2Builder(namespace=" + this.namespace + ", channel=" + this.channel + ", deleted=" + this.deleted + ", matchID=" + this.matchID + ", partyID=" + this.partyID + ", sessionType=" + this.sessionType + ", status=" + this.status + ", userID=" + this.userID + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }
}

