/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.sessionbrowser.operations.session;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.sessionbrowser.models.ModelsSessionQueryResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UserQuerySession
extends Operation {
    private String path = "/sessionbrowser/namespaces/{namespace}/gamesession";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String gameMode;
    private String gameVersion;
    private String joinable;
    private Integer limit;
    private String matchExist;
    private String matchId;
    private Integer offset;
    private String serverStatus;
    private String userId;
    private String sessionType;

    @Deprecated
    public UserQuerySession(String namespace, String gameMode, String gameVersion, String joinable, Integer limit, String matchExist, String matchId, Integer offset, String serverStatus, String userId, String sessionType) {
        this.namespace = namespace;
        this.gameMode = gameMode;
        this.gameVersion = gameVersion;
        this.joinable = joinable;
        this.limit = limit;
        this.matchExist = matchExist;
        this.matchId = matchId;
        this.offset = offset;
        this.serverStatus = serverStatus;
        this.userId = userId;
        this.sessionType = sessionType;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("game_mode", this.gameMode == null ? null : Arrays.asList(this.gameMode));
        queryParams.put("game_version", this.gameVersion == null ? null : Arrays.asList(this.gameVersion));
        queryParams.put("joinable", this.joinable == null ? null : Arrays.asList(this.joinable));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("match_exist", this.matchExist == null ? null : Arrays.asList(this.matchExist));
        queryParams.put("match_id", this.matchId == null ? null : Arrays.asList(this.matchId));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("server_status", this.serverStatus == null ? null : Arrays.asList(this.serverStatus));
        queryParams.put("user_id", this.userId == null ? null : Arrays.asList(this.userId));
        queryParams.put("session_type", this.sessionType == null ? null : Arrays.asList(this.sessionType));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.sessionType != null;
    }

    public ModelsSessionQueryResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsSessionQueryResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("game_mode", "None");
        result.put("game_version", "None");
        result.put("joinable", "None");
        result.put("limit", "None");
        result.put("match_exist", "None");
        result.put("match_id", "None");
        result.put("offset", "None");
        result.put("server_status", "None");
        result.put("user_id", "None");
        result.put("session_type", "None");
        return result;
    }

    public static UserQuerySessionBuilder builder() {
        return new UserQuerySessionBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getGameMode() {
        return this.gameMode;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public String getJoinable() {
        return this.joinable;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getMatchExist() {
        return this.matchExist;
    }

    public String getMatchId() {
        return this.matchId;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getServerStatus() {
        return this.serverStatus;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setGameMode(String gameMode) {
        this.gameMode = gameMode;
    }

    public void setGameVersion(String gameVersion) {
        this.gameVersion = gameVersion;
    }

    public void setJoinable(String joinable) {
        this.joinable = joinable;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setMatchExist(String matchExist) {
        this.matchExist = matchExist;
    }

    public void setMatchId(String matchId) {
        this.matchId = matchId;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setServerStatus(String serverStatus) {
        this.serverStatus = serverStatus;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setSessionType(String sessionType) {
        this.sessionType = sessionType;
    }

    public static class UserQuerySessionBuilder {
        private String namespace;
        private String gameMode;
        private String gameVersion;
        private String joinable;
        private Integer limit;
        private String matchExist;
        private String matchId;
        private Integer offset;
        private String serverStatus;
        private String userId;
        private String sessionType;

        UserQuerySessionBuilder() {
        }

        public UserQuerySessionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UserQuerySessionBuilder gameMode(String gameMode) {
            this.gameMode = gameMode;
            return this;
        }

        public UserQuerySessionBuilder gameVersion(String gameVersion) {
            this.gameVersion = gameVersion;
            return this;
        }

        public UserQuerySessionBuilder joinable(String joinable) {
            this.joinable = joinable;
            return this;
        }

        public UserQuerySessionBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public UserQuerySessionBuilder matchExist(String matchExist) {
            this.matchExist = matchExist;
            return this;
        }

        public UserQuerySessionBuilder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public UserQuerySessionBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public UserQuerySessionBuilder serverStatus(String serverStatus) {
            this.serverStatus = serverStatus;
            return this;
        }

        public UserQuerySessionBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public UserQuerySessionBuilder sessionType(String sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public UserQuerySession build() {
            return new UserQuerySession(this.namespace, this.gameMode, this.gameVersion, this.joinable, this.limit, this.matchExist, this.matchId, this.offset, this.serverStatus, this.userId, this.sessionType);
        }

        public String toString() {
            return "UserQuerySession.UserQuerySessionBuilder(namespace=" + this.namespace + ", gameMode=" + this.gameMode + ", gameVersion=" + this.gameVersion + ", joinable=" + this.joinable + ", limit=" + this.limit + ", matchExist=" + this.matchExist + ", matchId=" + this.matchId + ", offset=" + this.offset + ", serverStatus=" + this.serverStatus + ", userId=" + this.userId + ", sessionType=" + this.sessionType + ")";
        }
    }
}

