/*
 * Copyright (c) 2022 AccelByte Inc. All Rights Reserved
 * This is licensed software from AccelByte Inc, for limitations
 * and restrictions contact your company contract manager.
 *
 * Code generated. DO NOT EDIT.
 */

package net.accelbyte.sdk.api.session.operations.player;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.*;
import java.util.*;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import net.accelbyte.sdk.api.session.models.*;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

/**
 * adminQueryPlayerAttributes
 *
 * <p>Admin get attributes of players.
 *
 * <p>Field descriptions: - userID : user who owns the attributes. - crossplayEnabled : set to true
 * if the player wants to enable crossplay to their session (default: false). - platforms : list of
 * the player's 3rd party platform account information. - name : platform name. supported platforms:
 * STEAM, XBOX, PSN - userID : platform userID - data : other data that the player wants to store. -
 * PSN_PUSH_CONTEXT_ID: if provided, session will refer to this when performing session sync with
 * PSN, otherwise will populate from session attributes, otherwise will populate from session
 * attributes - currentPlatform : latest user game platform. - roles : user role for matchmaking
 * role base support.
 */
@Getter
@Setter
public class AdminQueryPlayerAttributes extends Operation {
  /** generated field's value */
  private String path = "/session/v1/admin/namespaces/{namespace}/users/attributes";

  private String method = "GET";
  private List<String> consumes = Arrays.asList("application/json");
  private List<String> produces = Arrays.asList("application/json");
  private String locationQuery = null;

  /** fields as input parameter */
  private String namespace;

  private String users;

  /**
   * @param namespace required
   */
  @Builder
  // @deprecated 2022-08-29 - All args constructor may cause problems. Use builder instead.
  @Deprecated
  public AdminQueryPlayerAttributes(String namespace, String users) {
    this.namespace = namespace;
    this.users = users;

    securities.add("Bearer");
  }

  @Override
  public Map<String, String> getPathParams() {
    Map<String, String> pathParams = new HashMap<>();
    if (this.namespace != null) {
      pathParams.put("namespace", this.namespace);
    }
    return pathParams;
  }

  @Override
  public Map<String, List<String>> getQueryParams() {
    Map<String, List<String>> queryParams = new HashMap<>();
    queryParams.put("users", this.users == null ? null : Arrays.asList(this.users));
    return queryParams;
  }

  @Override
  public boolean isValid() {
    if (this.namespace == null) {
      return false;
    }
    return true;
  }

  public List<ApimodelsPlayerAttributesResponseBody> parseResponse(
      int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
    if (code != 200) {
      final String json = Helper.convertInputStreamToString(payload);
      throw new HttpResponseException(code, json);
    }
    final String json = Helper.convertInputStreamToString(payload);
    return new ObjectMapper()
        .readValue(json, new TypeReference<List<ApimodelsPlayerAttributesResponseBody>>() {});
  }

  @Override
  protected Map<String, String> getCollectionFormatMap() {
    Map<String, String> result = new HashMap<>();
    result.put("users", "None");
    return result;
  }
}
