/*
 * Copyright (c) 2022 AccelByte Inc. All Rights Reserved
 * This is licensed software from AccelByte Inc, for limitations
 * and restrictions contact your company contract manager.
 *
 * Code generated. DO NOT EDIT.
 */

package net.accelbyte.sdk.api.platform.operations.section;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.*;
import java.util.*;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import net.accelbyte.sdk.api.platform.models.*;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

/**
 * publicListActiveSections
 *
 * <p>This API is used to list active section contents.
 *
 * <p>Other detail info:
 *
 * <p>* Required permission : resource=NAMESPACE:{namespace}:USER:{userId}:STORE, action=2 (READ) *
 * Optional permission : resource="PREVIEW", action=1(CREATE) (user with this permission can view
 * draft store sections) * Optional permission : resource="SANDBOX", action=1(CREATE) (user with
 * this permission can view draft store sections) * Returns : active section contents
 */
@Getter
@Setter
public class PublicListActiveSections extends Operation {
  /** generated field's value */
  private String path = "/platform/public/namespaces/{namespace}/users/{userId}/sections";

  private String method = "GET";
  private List<String> consumes = Arrays.asList();
  private List<String> produces = Arrays.asList("application/json");
  private String locationQuery = null;

  /** fields as input parameter */
  private String namespace;

  private String userId;
  private Boolean autoCalcEstimatedPrice;
  private String language;
  private String region;
  private String storeId;
  private String viewId;

  /**
   * @param namespace required
   * @param userId required
   */
  @Builder
  // @deprecated 2022-08-29 - All args constructor may cause problems. Use builder instead.
  @Deprecated
  public PublicListActiveSections(
      String namespace,
      String userId,
      Boolean autoCalcEstimatedPrice,
      String language,
      String region,
      String storeId,
      String viewId) {
    this.namespace = namespace;
    this.userId = userId;
    this.autoCalcEstimatedPrice = autoCalcEstimatedPrice;
    this.language = language;
    this.region = region;
    this.storeId = storeId;
    this.viewId = viewId;

    securities.add("Bearer");
  }

  @Override
  public Map<String, String> getPathParams() {
    Map<String, String> pathParams = new HashMap<>();
    if (this.namespace != null) {
      pathParams.put("namespace", this.namespace);
    }
    if (this.userId != null) {
      pathParams.put("userId", this.userId);
    }
    return pathParams;
  }

  @Override
  public Map<String, List<String>> getQueryParams() {
    Map<String, List<String>> queryParams = new HashMap<>();
    queryParams.put(
        "autoCalcEstimatedPrice",
        this.autoCalcEstimatedPrice == null
            ? null
            : Arrays.asList(String.valueOf(this.autoCalcEstimatedPrice)));
    queryParams.put("language", this.language == null ? null : Arrays.asList(this.language));
    queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
    queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
    queryParams.put("viewId", this.viewId == null ? null : Arrays.asList(this.viewId));
    return queryParams;
  }

  @Override
  public boolean isValid() {
    if (this.namespace == null) {
      return false;
    }
    if (this.userId == null) {
      return false;
    }
    return true;
  }

  public List<SectionInfo> parseResponse(int code, String contentType, InputStream payload)
      throws HttpResponseException, IOException {
    if (code != 200) {
      final String json = Helper.convertInputStreamToString(payload);
      throw new HttpResponseException(code, json);
    }
    final String json = Helper.convertInputStreamToString(payload);
    return new ObjectMapper().readValue(json, new TypeReference<List<SectionInfo>>() {});
  }

  @Override
  protected Map<String, String> getCollectionFormatMap() {
    Map<String, String> result = new HashMap<>();
    result.put("autoCalcEstimatedPrice", "None");
    result.put("language", "None");
    result.put("region", "None");
    result.put("storeId", "None");
    result.put("viewId", "None");
    return result;
  }
}
