/*
 * Copyright (c) 2022 AccelByte Inc. All Rights Reserved
 * This is licensed software from AccelByte Inc, for limitations
 * and restrictions contact your company contract manager.
 *
 * Code generated. DO NOT EDIT.
 */

package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.*;
import lombok.*;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown = true)
@Builder
@Getter
@Setter
// @deprecated 2022-08-29 - All args constructor may cause problems. Use builder instead.
@AllArgsConstructor(onConstructor = @__(@Deprecated))
@NoArgsConstructor
public class UserDLCRecord extends Model {

  @JsonProperty("entitlementOriginSyncResult")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private List<EntitlementOriginSyncResult> entitlementOriginSyncResult;

  @JsonProperty("entitlementOriginSyncStatus")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String entitlementOriginSyncStatus;

  @JsonProperty("id")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String id;

  @JsonProperty("metadata")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private Map<String, ?> metadata;

  @JsonProperty("namespace")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String namespace;

  @JsonProperty("obtainedAt")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String obtainedAt;

  @JsonProperty("platform")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String platform;

  @JsonProperty("revocationResult")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private RevocationResult revocationResult;

  @JsonProperty("revokeResults")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private List<RevokeResult> revokeResults;

  @JsonProperty("revokedAt")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String revokedAt;

  @JsonProperty("rewards")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private List<PlatformReward> rewards;

  @JsonProperty("sources")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private List<String> sources;

  @JsonProperty("status")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String status;

  @JsonProperty("transactionId")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String transactionId;

  @JsonProperty("userId")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String userId;

  @JsonProperty("version")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private Integer version;

  @JsonIgnore
  public String getEntitlementOriginSyncStatus() {
    return this.entitlementOriginSyncStatus;
  }

  @JsonIgnore
  public EntitlementOriginSyncStatus getEntitlementOriginSyncStatusAsEnum() {
    return EntitlementOriginSyncStatus.valueOf(this.entitlementOriginSyncStatus);
  }

  @JsonIgnore
  public void setEntitlementOriginSyncStatus(final String entitlementOriginSyncStatus) {
    this.entitlementOriginSyncStatus = entitlementOriginSyncStatus;
  }

  @JsonIgnore
  public void setEntitlementOriginSyncStatusFromEnum(
      final EntitlementOriginSyncStatus entitlementOriginSyncStatus) {
    this.entitlementOriginSyncStatus = entitlementOriginSyncStatus.toString();
  }

  @JsonIgnore
  public String getPlatform() {
    return this.platform;
  }

  @JsonIgnore
  public Platform getPlatformAsEnum() {
    return Platform.valueOf(this.platform);
  }

  @JsonIgnore
  public void setPlatform(final String platform) {
    this.platform = platform;
  }

  @JsonIgnore
  public void setPlatformFromEnum(final Platform platform) {
    this.platform = platform.toString();
  }

  @JsonIgnore
  public String getStatus() {
    return this.status;
  }

  @JsonIgnore
  public Status getStatusAsEnum() {
    return Status.valueOf(this.status);
  }

  @JsonIgnore
  public void setStatus(final String status) {
    this.status = status;
  }

  @JsonIgnore
  public void setStatusFromEnum(final Status status) {
    this.status = status.toString();
  }

  @JsonIgnore
  public UserDLCRecord createFromJson(String json) throws JsonProcessingException {
    return new ObjectMapper().readValue(json, this.getClass());
  }

  @JsonIgnore
  public List<UserDLCRecord> createFromJsonList(String json) throws JsonProcessingException {
    return new ObjectMapper().readValue(json, new TypeReference<List<UserDLCRecord>>() {});
  }

  public enum EntitlementOriginSyncStatus {
    NOTSYNCED("NOT_SYNCED"),
    SYNCED("SYNCED"),
    SYNCEDFAILED("SYNCED_FAILED");

    private String value;

    EntitlementOriginSyncStatus(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return this.value;
    }
  }

  public enum Platform {
    EPICGAMES("EPICGAMES"),
    OCULUS("OCULUS"),
    PSN("PSN"),
    STEAM("STEAM"),
    XBOX("XBOX");

    private String value;

    Platform(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return this.value;
    }
  }

  public enum Status {
    FULFILLED("FULFILLED"),
    REVOKED("REVOKED"),
    REVOKEFAILED("REVOKE_FAILED");

    private String value;

    Status(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return this.value;
    }
  }

  public static class UserDLCRecordBuilder {
    private String entitlementOriginSyncStatus;
    private String platform;
    private String status;

    public UserDLCRecordBuilder entitlementOriginSyncStatus(
        final String entitlementOriginSyncStatus) {
      this.entitlementOriginSyncStatus = entitlementOriginSyncStatus;
      return this;
    }

    public UserDLCRecordBuilder entitlementOriginSyncStatusFromEnum(
        final EntitlementOriginSyncStatus entitlementOriginSyncStatus) {
      this.entitlementOriginSyncStatus = entitlementOriginSyncStatus.toString();
      return this;
    }

    public UserDLCRecordBuilder platform(final String platform) {
      this.platform = platform;
      return this;
    }

    public UserDLCRecordBuilder platformFromEnum(final Platform platform) {
      this.platform = platform.toString();
      return this;
    }

    public UserDLCRecordBuilder status(final String status) {
      this.status = status;
      return this;
    }

    public UserDLCRecordBuilder statusFromEnum(final Status status) {
      this.status = status.toString();
      return this;
    }
  }
}
