/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.wallet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PlatformWallet;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetWallet
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/wallets/{currencyCode}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String currencyCode;
    private String namespace;
    private String userId;

    @Deprecated
    public PublicGetWallet(String currencyCode, String namespace, String userId) {
        this.currencyCode = currencyCode;
        this.namespace = namespace;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.currencyCode != null) {
            pathParams.put("currencyCode", this.currencyCode);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.currencyCode == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public PlatformWallet parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new PlatformWallet().createFromJson(json);
    }

    public static PublicGetWalletBuilder builder() {
        return new PublicGetWalletBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class PublicGetWalletBuilder {
        private String currencyCode;
        private String namespace;
        private String userId;

        PublicGetWalletBuilder() {
        }

        public PublicGetWalletBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public PublicGetWalletBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetWalletBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicGetWallet build() {
            return new PublicGetWallet(this.currencyCode, this.namespace, this.userId);
        }

        public String toString() {
            return "PublicGetWallet.PublicGetWalletBuilder(currencyCode=" + this.currencyCode + ", namespace=" + this.namespace + ", userId=" + this.userId + ")";
        }
    }
}

