/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.wallet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PlatformWalletConfigInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetPlatformWalletConfig
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/platforms/{platform}/wallet/config";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String platform;

    @Deprecated
    public GetPlatformWalletConfig(String namespace, String platform) {
        this.namespace = namespace;
        this.platform = platform;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.platform != null) {
            pathParams.put("platform", this.platform);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.platform != null;
    }

    public PlatformWalletConfigInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new PlatformWalletConfigInfo().createFromJson(json);
    }

    public static GetPlatformWalletConfigBuilder builder() {
        return new GetPlatformWalletConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public static class GetPlatformWalletConfigBuilder {
        private String namespace;
        private String platform;

        public GetPlatformWalletConfigBuilder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public GetPlatformWalletConfigBuilder platformFromEnum(Platform platform) {
            this.platform = platform.toString();
            return this;
        }

        GetPlatformWalletConfigBuilder() {
        }

        public GetPlatformWalletConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetPlatformWalletConfig build() {
            return new GetPlatformWalletConfig(this.namespace, this.platform);
        }

        public String toString() {
            return "GetPlatformWalletConfig.GetPlatformWalletConfigBuilder(namespace=" + this.namespace + ", platform=" + this.platform + ")";
        }
    }

    public static enum Platform {
        Epic("Epic"),
        GooglePlay("GooglePlay"),
        IOS("IOS"),
        Nintendo("Nintendo"),
        Oculus("Oculus"),
        Other("Other"),
        Playstation("Playstation"),
        Steam("Steam"),
        Xbox("Xbox");

        private String value;

        private Platform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

