/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.wallet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.DebitByCurrencyCodeRequest;
import net.accelbyte.sdk.api.platform.models.WalletInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DebitUserWalletByCurrencyCode
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/wallets/currencies/{currencyCode}/debit";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String currencyCode;
    private String namespace;
    private String userId;
    private DebitByCurrencyCodeRequest body;

    @Deprecated
    public DebitUserWalletByCurrencyCode(String currencyCode, String namespace, String userId, DebitByCurrencyCodeRequest body) {
        this.currencyCode = currencyCode;
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.currencyCode != null) {
            pathParams.put("currencyCode", this.currencyCode);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public DebitByCurrencyCodeRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.currencyCode == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public WalletInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new WalletInfo().createFromJson(json);
    }

    public static DebitUserWalletByCurrencyCodeBuilder builder() {
        return new DebitUserWalletByCurrencyCodeBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public DebitByCurrencyCodeRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(DebitByCurrencyCodeRequest body) {
        this.body = body;
    }

    public static class DebitUserWalletByCurrencyCodeBuilder {
        private String currencyCode;
        private String namespace;
        private String userId;
        private DebitByCurrencyCodeRequest body;

        DebitUserWalletByCurrencyCodeBuilder() {
        }

        public DebitUserWalletByCurrencyCodeBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public DebitUserWalletByCurrencyCodeBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DebitUserWalletByCurrencyCodeBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public DebitUserWalletByCurrencyCodeBuilder body(DebitByCurrencyCodeRequest body) {
            this.body = body;
            return this;
        }

        public DebitUserWalletByCurrencyCode build() {
            return new DebitUserWalletByCurrencyCode(this.currencyCode, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "DebitUserWalletByCurrencyCode.DebitUserWalletByCurrencyCodeBuilder(currencyCode=" + this.currencyCode + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

