/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.view;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DeleteView
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/views/{viewId}";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String viewId;
    private String storeId;

    @Deprecated
    public DeleteView(String namespace, String viewId, String storeId) {
        this.namespace = namespace;
        this.viewId = viewId;
        this.storeId = storeId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.viewId != null) {
            pathParams.put("viewId", this.viewId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.viewId == null) {
            return false;
        }
        return this.storeId != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("storeId", "None");
        return result;
    }

    public static DeleteViewBuilder builder() {
        return new DeleteViewBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public static class DeleteViewBuilder {
        private String namespace;
        private String viewId;
        private String storeId;

        DeleteViewBuilder() {
        }

        public DeleteViewBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DeleteViewBuilder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public DeleteViewBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public DeleteView build() {
            return new DeleteView(this.namespace, this.viewId, this.storeId);
        }

        public String toString() {
            return "DeleteView.DeleteViewBuilder(namespace=" + this.namespace + ", viewId=" + this.viewId + ", storeId=" + this.storeId + ")";
        }
    }
}

