/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.RecurringChargeResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RecurringChargeSubscription
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/subscriptions/{subscriptionId}/recurring";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String subscriptionId;

    @Deprecated
    public RecurringChargeSubscription(String namespace, String subscriptionId) {
        this.namespace = namespace;
        this.subscriptionId = subscriptionId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.subscriptionId != null) {
            pathParams.put("subscriptionId", this.subscriptionId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.subscriptionId != null;
    }

    public RecurringChargeResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new RecurringChargeResult().createFromJson(json);
    }

    public static RecurringChargeSubscriptionBuilder builder() {
        return new RecurringChargeSubscriptionBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public static class RecurringChargeSubscriptionBuilder {
        private String namespace;
        private String subscriptionId;

        RecurringChargeSubscriptionBuilder() {
        }

        public RecurringChargeSubscriptionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RecurringChargeSubscriptionBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public RecurringChargeSubscription build() {
            return new RecurringChargeSubscription(this.namespace, this.subscriptionId);
        }

        public String toString() {
            return "RecurringChargeSubscription.RecurringChargeSubscriptionBuilder(namespace=" + this.namespace + ", subscriptionId=" + this.subscriptionId + ")";
        }
    }
}

