/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.SubscriptionPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QuerySubscriptions
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/subscriptions";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String chargeStatus;
    private String itemId;
    private Integer limit;
    private Integer offset;
    private String sku;
    private String status;
    private String subscribedBy;
    private String userId;

    @Deprecated
    public QuerySubscriptions(String namespace, String chargeStatus, String itemId, Integer limit, Integer offset, String sku, String status, String subscribedBy, String userId) {
        this.namespace = namespace;
        this.chargeStatus = chargeStatus;
        this.itemId = itemId;
        this.limit = limit;
        this.offset = offset;
        this.sku = sku;
        this.status = status;
        this.subscribedBy = subscribedBy;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("chargeStatus", this.chargeStatus == null ? null : Arrays.asList(this.chargeStatus));
        queryParams.put("itemId", this.itemId == null ? null : Arrays.asList(this.itemId));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sku", this.sku == null ? null : Arrays.asList(this.sku));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        queryParams.put("subscribedBy", this.subscribedBy == null ? null : Arrays.asList(this.subscribedBy));
        queryParams.put("userId", this.userId == null ? null : Arrays.asList(this.userId));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public SubscriptionPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new SubscriptionPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("chargeStatus", "None");
        result.put("itemId", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("sku", "None");
        result.put("status", "None");
        result.put("subscribedBy", "None");
        result.put("userId", "None");
        return result;
    }

    public static QuerySubscriptionsBuilder builder() {
        return new QuerySubscriptionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getChargeStatus() {
        return this.chargeStatus;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSku() {
        return this.sku;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSubscribedBy() {
        return this.subscribedBy;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setChargeStatus(String chargeStatus) {
        this.chargeStatus = chargeStatus;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSubscribedBy(String subscribedBy) {
        this.subscribedBy = subscribedBy;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class QuerySubscriptionsBuilder {
        private String namespace;
        private String itemId;
        private Integer limit;
        private Integer offset;
        private String sku;
        private String userId;
        private String chargeStatus;
        private String status;
        private String subscribedBy;

        public QuerySubscriptionsBuilder chargeStatus(String chargeStatus) {
            this.chargeStatus = chargeStatus;
            return this;
        }

        public QuerySubscriptionsBuilder chargeStatusFromEnum(ChargeStatus chargeStatus) {
            this.chargeStatus = chargeStatus.toString();
            return this;
        }

        public QuerySubscriptionsBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QuerySubscriptionsBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        public QuerySubscriptionsBuilder subscribedBy(String subscribedBy) {
            this.subscribedBy = subscribedBy;
            return this;
        }

        public QuerySubscriptionsBuilder subscribedByFromEnum(SubscribedBy subscribedBy) {
            this.subscribedBy = subscribedBy.toString();
            return this;
        }

        QuerySubscriptionsBuilder() {
        }

        public QuerySubscriptionsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QuerySubscriptionsBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public QuerySubscriptionsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QuerySubscriptionsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QuerySubscriptionsBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public QuerySubscriptionsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QuerySubscriptions build() {
            return new QuerySubscriptions(this.namespace, this.chargeStatus, this.itemId, this.limit, this.offset, this.sku, this.status, this.subscribedBy, this.userId);
        }

        public String toString() {
            return "QuerySubscriptions.QuerySubscriptionsBuilder(namespace=" + this.namespace + ", chargeStatus=" + this.chargeStatus + ", itemId=" + this.itemId + ", limit=" + this.limit + ", offset=" + this.offset + ", sku=" + this.sku + ", status=" + this.status + ", subscribedBy=" + this.subscribedBy + ", userId=" + this.userId + ")";
        }
    }

    public static enum SubscribedBy {
        PLATFORM("PLATFORM"),
        USER("USER");

        private String value;

        private SubscribedBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Status {
        ACTIVE("ACTIVE"),
        CANCELLED("CANCELLED"),
        EXPIRED("EXPIRED"),
        INIT("INIT");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ChargeStatus {
        CHARGED("CHARGED"),
        CHARGEFAILED("CHARGE_FAILED"),
        NEVER("NEVER"),
        RECURRINGCHARGING("RECURRING_CHARGING"),
        SETUP("SETUP");

        private String value;

        private ChargeStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

