/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CancelRequest;
import net.accelbyte.sdk.api.platform.models.SubscriptionInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicCancelSubscription
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/subscriptions/{subscriptionId}/cancel";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String subscriptionId;
    private String userId;
    private CancelRequest body;

    @Deprecated
    public PublicCancelSubscription(String namespace, String subscriptionId, String userId, CancelRequest body) {
        this.namespace = namespace;
        this.subscriptionId = subscriptionId;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.subscriptionId != null) {
            pathParams.put("subscriptionId", this.subscriptionId);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public CancelRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.subscriptionId == null) {
            return false;
        }
        return this.userId != null;
    }

    public SubscriptionInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new SubscriptionInfo().createFromJson(json);
    }

    public static PublicCancelSubscriptionBuilder builder() {
        return new PublicCancelSubscriptionBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public CancelRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(CancelRequest body) {
        this.body = body;
    }

    public static class PublicCancelSubscriptionBuilder {
        private String namespace;
        private String subscriptionId;
        private String userId;
        private CancelRequest body;

        PublicCancelSubscriptionBuilder() {
        }

        public PublicCancelSubscriptionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicCancelSubscriptionBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public PublicCancelSubscriptionBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicCancelSubscriptionBuilder body(CancelRequest body) {
            this.body = body;
            return this;
        }

        public PublicCancelSubscription build() {
            return new PublicCancelSubscription(this.namespace, this.subscriptionId, this.userId, this.body);
        }

        public String toString() {
            return "PublicCancelSubscription.PublicCancelSubscriptionBuilder(namespace=" + this.namespace + ", subscriptionId=" + this.subscriptionId + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

