/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.TradeNotification;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ProcessUserSubscriptionNotification
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/subscriptions/{subscriptionId}/notifications";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String subscriptionId;
    private String userId;
    private TradeNotification body;

    @Deprecated
    public ProcessUserSubscriptionNotification(String namespace, String subscriptionId, String userId, TradeNotification body) {
        this.namespace = namespace;
        this.subscriptionId = subscriptionId;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.subscriptionId != null) {
            pathParams.put("subscriptionId", this.subscriptionId);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public TradeNotification getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.subscriptionId == null) {
            return false;
        }
        return this.userId != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static ProcessUserSubscriptionNotificationBuilder builder() {
        return new ProcessUserSubscriptionNotificationBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public TradeNotification getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(TradeNotification body) {
        this.body = body;
    }

    public static class ProcessUserSubscriptionNotificationBuilder {
        private String namespace;
        private String subscriptionId;
        private String userId;
        private TradeNotification body;

        ProcessUserSubscriptionNotificationBuilder() {
        }

        public ProcessUserSubscriptionNotificationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ProcessUserSubscriptionNotificationBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public ProcessUserSubscriptionNotificationBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public ProcessUserSubscriptionNotificationBuilder body(TradeNotification body) {
            this.body = body;
            return this;
        }

        public ProcessUserSubscriptionNotification build() {
            return new ProcessUserSubscriptionNotification(this.namespace, this.subscriptionId, this.userId, this.body);
        }

        public String toString() {
            return "ProcessUserSubscriptionNotification.ProcessUserSubscriptionNotificationBuilder(namespace=" + this.namespace + ", subscriptionId=" + this.subscriptionId + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

