/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.SubscriptionActivityPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetUserSubscriptionActivities
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/subscriptions/activities";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private Boolean excludeSystem;
    private Integer limit;
    private Integer offset;
    private String subscriptionId;

    @Deprecated
    public GetUserSubscriptionActivities(String namespace, String userId, Boolean excludeSystem, Integer limit, Integer offset, String subscriptionId) {
        this.namespace = namespace;
        this.userId = userId;
        this.excludeSystem = excludeSystem;
        this.limit = limit;
        this.offset = offset;
        this.subscriptionId = subscriptionId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("excludeSystem", this.excludeSystem == null ? null : Arrays.asList(String.valueOf(this.excludeSystem)));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("subscriptionId", this.subscriptionId == null ? null : Arrays.asList(this.subscriptionId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public SubscriptionActivityPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new SubscriptionActivityPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("excludeSystem", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("subscriptionId", "None");
        return result;
    }

    public static GetUserSubscriptionActivitiesBuilder builder() {
        return new GetUserSubscriptionActivitiesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getExcludeSystem() {
        return this.excludeSystem;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setExcludeSystem(Boolean excludeSystem) {
        this.excludeSystem = excludeSystem;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public static class GetUserSubscriptionActivitiesBuilder {
        private String namespace;
        private String userId;
        private Boolean excludeSystem;
        private Integer limit;
        private Integer offset;
        private String subscriptionId;

        GetUserSubscriptionActivitiesBuilder() {
        }

        public GetUserSubscriptionActivitiesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetUserSubscriptionActivitiesBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public GetUserSubscriptionActivitiesBuilder excludeSystem(Boolean excludeSystem) {
            this.excludeSystem = excludeSystem;
            return this;
        }

        public GetUserSubscriptionActivitiesBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetUserSubscriptionActivitiesBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetUserSubscriptionActivitiesBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public GetUserSubscriptionActivities build() {
            return new GetUserSubscriptionActivities(this.namespace, this.userId, this.excludeSystem, this.limit, this.offset, this.subscriptionId);
        }

        public String toString() {
            return "GetUserSubscriptionActivities.GetUserSubscriptionActivitiesBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", excludeSystem=" + this.excludeSystem + ", limit=" + this.limit + ", offset=" + this.offset + ", subscriptionId=" + this.subscriptionId + ")";
        }
    }
}

