/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CancelRequest;
import net.accelbyte.sdk.api.platform.models.SubscriptionInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CancelSubscription
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/subscriptions/{subscriptionId}/cancel";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String subscriptionId;
    private String userId;
    private Boolean force;
    private CancelRequest body;

    @Deprecated
    public CancelSubscription(String namespace, String subscriptionId, String userId, Boolean force, CancelRequest body) {
        this.namespace = namespace;
        this.subscriptionId = subscriptionId;
        this.userId = userId;
        this.force = force;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.subscriptionId != null) {
            pathParams.put("subscriptionId", this.subscriptionId);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("force", this.force == null ? null : Arrays.asList(String.valueOf(this.force)));
        return queryParams;
    }

    public CancelRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.subscriptionId == null) {
            return false;
        }
        return this.userId != null;
    }

    public SubscriptionInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new SubscriptionInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("force", "None");
        return result;
    }

    public static CancelSubscriptionBuilder builder() {
        return new CancelSubscriptionBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getForce() {
        return this.force;
    }

    public CancelRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public void setBody(CancelRequest body) {
        this.body = body;
    }

    public static class CancelSubscriptionBuilder {
        private String namespace;
        private String subscriptionId;
        private String userId;
        private Boolean force;
        private CancelRequest body;

        CancelSubscriptionBuilder() {
        }

        public CancelSubscriptionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CancelSubscriptionBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public CancelSubscriptionBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public CancelSubscriptionBuilder force(Boolean force) {
            this.force = force;
            return this;
        }

        public CancelSubscriptionBuilder body(CancelRequest body) {
            this.body = body;
            return this;
        }

        public CancelSubscription build() {
            return new CancelSubscription(this.namespace, this.subscriptionId, this.userId, this.force, this.body);
        }

        public String toString() {
            return "CancelSubscription.CancelSubscriptionBuilder(namespace=" + this.namespace + ", subscriptionId=" + this.subscriptionId + ", userId=" + this.userId + ", force=" + this.force + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

