/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.StoreInfo;
import net.accelbyte.sdk.api.platform.models.StoreUpdate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateStore
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/stores/{storeId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String storeId;
    private StoreUpdate body;

    @Deprecated
    public UpdateStore(String namespace, String storeId, StoreUpdate body) {
        this.namespace = namespace;
        this.storeId = storeId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.storeId != null) {
            pathParams.put("storeId", this.storeId);
        }
        return pathParams;
    }

    public StoreUpdate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.storeId != null;
    }

    public StoreInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new StoreInfo().createFromJson(json);
    }

    public static UpdateStoreBuilder builder() {
        return new UpdateStoreBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public StoreUpdate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setBody(StoreUpdate body) {
        this.body = body;
    }

    public static class UpdateStoreBuilder {
        private String namespace;
        private String storeId;
        private StoreUpdate body;

        UpdateStoreBuilder() {
        }

        public UpdateStoreBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateStoreBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public UpdateStoreBuilder body(StoreUpdate body) {
            this.body = body;
            return this;
        }

        public UpdateStore build() {
            return new UpdateStore(this.namespace, this.storeId, this.body);
        }

        public String toString() {
            return "UpdateStore.UpdateStoreBuilder(namespace=" + this.namespace + ", storeId=" + this.storeId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

