/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ExportStoreRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ExportStore1
extends Operation {
    private String path = "/platform/v2/admin/namespaces/{namespace}/stores/{storeId}/export";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/zip");
    private String locationQuery = null;
    private String namespace;
    private String storeId;
    private ExportStoreRequest body;

    @Deprecated
    public ExportStore1(String namespace, String storeId, ExportStoreRequest body) {
        this.namespace = namespace;
        this.storeId = storeId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.storeId != null) {
            pathParams.put("storeId", this.storeId);
        }
        return pathParams;
    }

    public ExportStoreRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.storeId != null;
    }

    public InputStream parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        return payload;
    }

    public static ExportStore1Builder builder() {
        return new ExportStore1Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public ExportStoreRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setBody(ExportStoreRequest body) {
        this.body = body;
    }

    public static class ExportStore1Builder {
        private String namespace;
        private String storeId;
        private ExportStoreRequest body;

        ExportStore1Builder() {
        }

        public ExportStore1Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ExportStore1Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public ExportStore1Builder body(ExportStoreRequest body) {
            this.body = body;
            return this;
        }

        public ExportStore1 build() {
            return new ExportStore1(this.namespace, this.storeId, this.body);
        }

        public String toString() {
            return "ExportStore1.ExportStore1Builder(namespace=" + this.namespace + ", storeId=" + this.storeId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

