/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.StoreInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CloneStore
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/stores/{storeId}/clone";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String storeId;
    private String targetStoreId;

    @Deprecated
    public CloneStore(String namespace, String storeId, String targetStoreId) {
        this.namespace = namespace;
        this.storeId = storeId;
        this.targetStoreId = targetStoreId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.storeId != null) {
            pathParams.put("storeId", this.storeId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("targetStoreId", this.targetStoreId == null ? null : Arrays.asList(this.targetStoreId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.storeId != null;
    }

    public StoreInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new StoreInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("targetStoreId", "None");
        return result;
    }

    public static CloneStoreBuilder builder() {
        return new CloneStoreBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getTargetStoreId() {
        return this.targetStoreId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setTargetStoreId(String targetStoreId) {
        this.targetStoreId = targetStoreId;
    }

    public static class CloneStoreBuilder {
        private String namespace;
        private String storeId;
        private String targetStoreId;

        CloneStoreBuilder() {
        }

        public CloneStoreBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CloneStoreBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public CloneStoreBuilder targetStoreId(String targetStoreId) {
            this.targetStoreId = targetStoreId;
            return this;
        }

        public CloneStore build() {
            return new CloneStore(this.namespace, this.storeId, this.targetStoreId);
        }

        public String toString() {
            return "CloneStore.CloneStoreBuilder(namespace=" + this.namespace + ", storeId=" + this.storeId + ", targetStoreId=" + this.targetStoreId + ")";
        }
    }
}

