/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.section;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.FullSectionInfo;
import net.accelbyte.sdk.api.platform.models.SectionUpdate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateSection
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/sections/{sectionId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String sectionId;
    private String storeId;
    private SectionUpdate body;

    @Deprecated
    public UpdateSection(String namespace, String sectionId, String storeId, SectionUpdate body) {
        this.namespace = namespace;
        this.sectionId = sectionId;
        this.storeId = storeId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.sectionId != null) {
            pathParams.put("sectionId", this.sectionId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        return queryParams;
    }

    public SectionUpdate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.sectionId == null) {
            return false;
        }
        return this.storeId != null;
    }

    public FullSectionInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new FullSectionInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("storeId", "None");
        return result;
    }

    public static UpdateSectionBuilder builder() {
        return new UpdateSectionBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public SectionUpdate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setBody(SectionUpdate body) {
        this.body = body;
    }

    public static class UpdateSectionBuilder {
        private String namespace;
        private String sectionId;
        private String storeId;
        private SectionUpdate body;

        UpdateSectionBuilder() {
        }

        public UpdateSectionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateSectionBuilder sectionId(String sectionId) {
            this.sectionId = sectionId;
            return this;
        }

        public UpdateSectionBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public UpdateSectionBuilder body(SectionUpdate body) {
            this.body = body;
            return this;
        }

        public UpdateSection build() {
            return new UpdateSection(this.namespace, this.sectionId, this.storeId, this.body);
        }

        public String toString() {
            return "UpdateSection.UpdateSectionBuilder(namespace=" + this.namespace + ", sectionId=" + this.sectionId + ", storeId=" + this.storeId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

