/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.section;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.SectionInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicListActiveSections
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/sections";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String language;
    private String region;
    private String storeId;
    private String viewId;

    @Deprecated
    public PublicListActiveSections(String namespace, String userId, String language, String region, String storeId, String viewId) {
        this.namespace = namespace;
        this.userId = userId;
        this.language = language;
        this.region = region;
        this.storeId = storeId;
        this.viewId = viewId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("language", this.language == null ? null : Arrays.asList(this.language));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("viewId", this.viewId == null ? null : Arrays.asList(this.viewId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public List<SectionInfo> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<SectionInfo>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("language", "None");
        result.put("region", "None");
        result.put("storeId", "None");
        result.put("viewId", "None");
        return result;
    }

    public static PublicListActiveSectionsBuilder builder() {
        return new PublicListActiveSectionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getRegion() {
        return this.region;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public static class PublicListActiveSectionsBuilder {
        private String namespace;
        private String userId;
        private String language;
        private String region;
        private String storeId;
        private String viewId;

        PublicListActiveSectionsBuilder() {
        }

        public PublicListActiveSectionsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicListActiveSectionsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicListActiveSectionsBuilder language(String language) {
            this.language = language;
            return this;
        }

        public PublicListActiveSectionsBuilder region(String region) {
            this.region = region;
            return this;
        }

        public PublicListActiveSectionsBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public PublicListActiveSectionsBuilder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public PublicListActiveSections build() {
            return new PublicListActiveSections(this.namespace, this.userId, this.language, this.region, this.storeId, this.viewId);
        }

        public String toString() {
            return "PublicListActiveSections.PublicListActiveSectionsBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", language=" + this.language + ", region=" + this.region + ", storeId=" + this.storeId + ", viewId=" + this.viewId + ")";
        }
    }
}

