/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.reward;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ConditionMatchResult;
import net.accelbyte.sdk.api.platform.models.EventPayload;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CheckEventCondition
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/rewards/{rewardId}/match";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String rewardId;
    private EventPayload body;

    @Deprecated
    public CheckEventCondition(String namespace, String rewardId, EventPayload body) {
        this.namespace = namespace;
        this.rewardId = rewardId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.rewardId != null) {
            pathParams.put("rewardId", this.rewardId);
        }
        return pathParams;
    }

    public EventPayload getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.rewardId != null;
    }

    public ConditionMatchResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ConditionMatchResult().createFromJson(json);
    }

    public static CheckEventConditionBuilder builder() {
        return new CheckEventConditionBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRewardId() {
        return this.rewardId;
    }

    public EventPayload getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setRewardId(String rewardId) {
        this.rewardId = rewardId;
    }

    public void setBody(EventPayload body) {
        this.body = body;
    }

    public static class CheckEventConditionBuilder {
        private String namespace;
        private String rewardId;
        private EventPayload body;

        CheckEventConditionBuilder() {
        }

        public CheckEventConditionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CheckEventConditionBuilder rewardId(String rewardId) {
            this.rewardId = rewardId;
            return this;
        }

        public CheckEventConditionBuilder body(EventPayload body) {
            this.body = body;
            return this;
        }

        public CheckEventCondition build() {
            return new CheckEventCondition(this.namespace, this.rewardId, this.body);
        }

        public String toString() {
            return "CheckEventCondition.CheckEventConditionBuilder(namespace=" + this.namespace + ", rewardId=" + this.rewardId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

