/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment_station;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PaymentProcessResult;
import net.accelbyte.sdk.api.platform.models.PaymentToken;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class Pay
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/payment/orders/{paymentOrderNo}/pay";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String paymentOrderNo;
    private String paymentProvider;
    private String zipCode;
    private PaymentToken body;

    @Deprecated
    public Pay(String namespace, String paymentOrderNo, String paymentProvider, String zipCode, PaymentToken body) {
        this.namespace = namespace;
        this.paymentOrderNo = paymentOrderNo;
        this.paymentProvider = paymentProvider;
        this.zipCode = zipCode;
        this.body = body;
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.paymentOrderNo != null) {
            pathParams.put("paymentOrderNo", this.paymentOrderNo);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("paymentProvider", this.paymentProvider == null ? null : Arrays.asList(this.paymentProvider));
        queryParams.put("zipCode", this.zipCode == null ? null : Arrays.asList(this.zipCode));
        return queryParams;
    }

    public PaymentToken getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.paymentOrderNo != null;
    }

    public PaymentProcessResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new PaymentProcessResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("paymentProvider", "None");
        result.put("zipCode", "None");
        return result;
    }

    public static PayBuilder builder() {
        return new PayBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPaymentOrderNo() {
        return this.paymentOrderNo;
    }

    public String getPaymentProvider() {
        return this.paymentProvider;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public PaymentToken getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPaymentOrderNo(String paymentOrderNo) {
        this.paymentOrderNo = paymentOrderNo;
    }

    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public void setBody(PaymentToken body) {
        this.body = body;
    }

    public static class PayBuilder {
        private String namespace;
        private String paymentOrderNo;
        private String zipCode;
        private PaymentToken body;
        private String paymentProvider;

        public PayBuilder paymentProvider(String paymentProvider) {
            this.paymentProvider = paymentProvider;
            return this;
        }

        public PayBuilder paymentProviderFromEnum(PaymentProvider paymentProvider) {
            this.paymentProvider = paymentProvider.toString();
            return this;
        }

        PayBuilder() {
        }

        public PayBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PayBuilder paymentOrderNo(String paymentOrderNo) {
            this.paymentOrderNo = paymentOrderNo;
            return this;
        }

        public PayBuilder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public PayBuilder body(PaymentToken body) {
            this.body = body;
            return this;
        }

        public Pay build() {
            return new Pay(this.namespace, this.paymentOrderNo, this.paymentProvider, this.zipCode, this.body);
        }

        public String toString() {
            return "Pay.PayBuilder(namespace=" + this.namespace + ", paymentOrderNo=" + this.paymentOrderNo + ", paymentProvider=" + this.paymentProvider + ", zipCode=" + this.zipCode + ", body=" + (Object)((Object)this.body) + ")";
        }
    }

    public static enum PaymentProvider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private PaymentProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

