/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment_station;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetPaymentPublicConfig
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/payment/publicconfig";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean sandbox;
    private String paymentProvider;
    private String region;

    @Deprecated
    public GetPaymentPublicConfig(String namespace, Boolean sandbox, String paymentProvider, String region) {
        this.namespace = namespace;
        this.sandbox = sandbox;
        this.paymentProvider = paymentProvider;
        this.region = region;
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("sandbox", this.sandbox == null ? null : Arrays.asList(String.valueOf(this.sandbox)));
        queryParams.put("paymentProvider", this.paymentProvider == null ? null : Arrays.asList(this.paymentProvider));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.paymentProvider == null) {
            return false;
        }
        return this.region != null;
    }

    public Map<String, ?> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (Map)new ObjectMapper().readValue(json, new TypeReference<Map<String, ?>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("sandbox", "None");
        result.put("paymentProvider", "None");
        result.put("region", "None");
        return result;
    }

    public static GetPaymentPublicConfigBuilder builder() {
        return new GetPaymentPublicConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getSandbox() {
        return this.sandbox;
    }

    public String getPaymentProvider() {
        return this.paymentProvider;
    }

    public String getRegion() {
        return this.region;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSandbox(Boolean sandbox) {
        this.sandbox = sandbox;
    }

    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public static class GetPaymentPublicConfigBuilder {
        private String namespace;
        private Boolean sandbox;
        private String region;
        private String paymentProvider;

        public GetPaymentPublicConfigBuilder paymentProvider(String paymentProvider) {
            this.paymentProvider = paymentProvider;
            return this;
        }

        public GetPaymentPublicConfigBuilder paymentProviderFromEnum(PaymentProvider paymentProvider) {
            this.paymentProvider = paymentProvider.toString();
            return this;
        }

        GetPaymentPublicConfigBuilder() {
        }

        public GetPaymentPublicConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetPaymentPublicConfigBuilder sandbox(Boolean sandbox) {
            this.sandbox = sandbox;
            return this;
        }

        public GetPaymentPublicConfigBuilder region(String region) {
            this.region = region;
            return this;
        }

        public GetPaymentPublicConfig build() {
            return new GetPaymentPublicConfig(this.namespace, this.sandbox, this.paymentProvider, this.region);
        }

        public String toString() {
            return "GetPaymentPublicConfig.GetPaymentPublicConfigBuilder(namespace=" + this.namespace + ", sandbox=" + this.sandbox + ", paymentProvider=" + this.paymentProvider + ", region=" + this.region + ")";
        }
    }

    public static enum PaymentProvider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private PaymentProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

