/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.NotificationProcessResult;
import net.accelbyte.sdk.api.platform.models.PaymentOrderNotifySimulation;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class SimulatePaymentOrderNotification
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/payment/orders/{paymentOrderNo}/simulate-notification";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String paymentOrderNo;
    private PaymentOrderNotifySimulation body;

    @Deprecated
    public SimulatePaymentOrderNotification(String namespace, String paymentOrderNo, PaymentOrderNotifySimulation body) {
        this.namespace = namespace;
        this.paymentOrderNo = paymentOrderNo;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.paymentOrderNo != null) {
            pathParams.put("paymentOrderNo", this.paymentOrderNo);
        }
        return pathParams;
    }

    public PaymentOrderNotifySimulation getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.paymentOrderNo != null;
    }

    public NotificationProcessResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new NotificationProcessResult().createFromJson(json);
    }

    public static SimulatePaymentOrderNotificationBuilder builder() {
        return new SimulatePaymentOrderNotificationBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPaymentOrderNo() {
        return this.paymentOrderNo;
    }

    public PaymentOrderNotifySimulation getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPaymentOrderNo(String paymentOrderNo) {
        this.paymentOrderNo = paymentOrderNo;
    }

    public void setBody(PaymentOrderNotifySimulation body) {
        this.body = body;
    }

    public static class SimulatePaymentOrderNotificationBuilder {
        private String namespace;
        private String paymentOrderNo;
        private PaymentOrderNotifySimulation body;

        SimulatePaymentOrderNotificationBuilder() {
        }

        public SimulatePaymentOrderNotificationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SimulatePaymentOrderNotificationBuilder paymentOrderNo(String paymentOrderNo) {
            this.paymentOrderNo = paymentOrderNo;
            return this;
        }

        public SimulatePaymentOrderNotificationBuilder body(PaymentOrderNotifySimulation body) {
            this.body = body;
            return this;
        }

        public SimulatePaymentOrderNotification build() {
            return new SimulatePaymentOrderNotification(this.namespace, this.paymentOrderNo, this.body);
        }

        public String toString() {
            return "SimulatePaymentOrderNotification.SimulatePaymentOrderNotificationBuilder(namespace=" + this.namespace + ", paymentOrderNo=" + this.paymentOrderNo + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

