/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PaymentOrderPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryPaymentOrders
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/payment/orders";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String channel;
    private String extTxId;
    private Integer limit;
    private Integer offset;
    private String status;

    @Deprecated
    public QueryPaymentOrders(String namespace, String channel, String extTxId, Integer limit, Integer offset, String status) {
        this.namespace = namespace;
        this.channel = channel;
        this.extTxId = extTxId;
        this.limit = limit;
        this.offset = offset;
        this.status = status;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("channel", this.channel == null ? null : Arrays.asList(this.channel));
        queryParams.put("extTxId", this.extTxId == null ? null : Arrays.asList(this.extTxId));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public PaymentOrderPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new PaymentOrderPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("channel", "None");
        result.put("extTxId", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("status", "None");
        return result;
    }

    public static QueryPaymentOrdersBuilder builder() {
        return new QueryPaymentOrdersBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getExtTxId() {
        return this.extTxId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getStatus() {
        return this.status;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setExtTxId(String extTxId) {
        this.extTxId = extTxId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class QueryPaymentOrdersBuilder {
        private String namespace;
        private String extTxId;
        private Integer limit;
        private Integer offset;
        private String channel;
        private String status;

        public QueryPaymentOrdersBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public QueryPaymentOrdersBuilder channelFromEnum(Channel channel) {
            this.channel = channel.toString();
            return this;
        }

        public QueryPaymentOrdersBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QueryPaymentOrdersBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        QueryPaymentOrdersBuilder() {
        }

        public QueryPaymentOrdersBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryPaymentOrdersBuilder extTxId(String extTxId) {
            this.extTxId = extTxId;
            return this;
        }

        public QueryPaymentOrdersBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryPaymentOrdersBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryPaymentOrders build() {
            return new QueryPaymentOrders(this.namespace, this.channel, this.extTxId, this.limit, this.offset, this.status);
        }

        public String toString() {
            return "QueryPaymentOrders.QueryPaymentOrdersBuilder(namespace=" + this.namespace + ", channel=" + this.channel + ", extTxId=" + this.extTxId + ", limit=" + this.limit + ", offset=" + this.offset + ", status=" + this.status + ")";
        }
    }

    public static enum Status {
        AUTHORISED("AUTHORISED"),
        AUTHORISEFAILED("AUTHORISE_FAILED"),
        CHARGEBACK("CHARGEBACK"),
        CHARGEBACKREVERSED("CHARGEBACK_REVERSED"),
        CHARGED("CHARGED"),
        CHARGEFAILED("CHARGE_FAILED"),
        DELETED("DELETED"),
        INIT("INIT"),
        NOTIFICATIONOFCHARGEBACK("NOTIFICATION_OF_CHARGEBACK"),
        REFUNDED("REFUNDED"),
        REFUNDING("REFUNDING"),
        REFUNDFAILED("REFUND_FAILED"),
        REQUESTFORINFORMATION("REQUEST_FOR_INFORMATION");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Channel {
        EXTERNAL("EXTERNAL"),
        INTERNAL("INTERNAL");

        private String value;

        private Channel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

