/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.order_dedicated;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.OrderSyncResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class SyncOrders
extends Operation {
    private String path = "/platform/admin/orders";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String nextEvaluatedKey;
    private String end;
    private String start;

    @Deprecated
    public SyncOrders(String nextEvaluatedKey, String end, String start) {
        this.nextEvaluatedKey = nextEvaluatedKey;
        this.end = end;
        this.start = start;
        this.securities.add("Bearer");
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("nextEvaluatedKey", this.nextEvaluatedKey == null ? null : Arrays.asList(this.nextEvaluatedKey));
        queryParams.put("end", this.end == null ? null : Arrays.asList(this.end));
        queryParams.put("start", this.start == null ? null : Arrays.asList(this.start));
        return queryParams;
    }

    public boolean isValid() {
        if (this.end == null) {
            return false;
        }
        return this.start != null;
    }

    public OrderSyncResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OrderSyncResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("nextEvaluatedKey", "None");
        result.put("end", "None");
        result.put("start", "None");
        return result;
    }

    public static SyncOrdersBuilder builder() {
        return new SyncOrdersBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNextEvaluatedKey() {
        return this.nextEvaluatedKey;
    }

    public String getEnd() {
        return this.end;
    }

    public String getStart() {
        return this.start;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNextEvaluatedKey(String nextEvaluatedKey) {
        this.nextEvaluatedKey = nextEvaluatedKey;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public static class SyncOrdersBuilder {
        private String nextEvaluatedKey;
        private String end;
        private String start;

        SyncOrdersBuilder() {
        }

        public SyncOrdersBuilder nextEvaluatedKey(String nextEvaluatedKey) {
            this.nextEvaluatedKey = nextEvaluatedKey;
            return this;
        }

        public SyncOrdersBuilder end(String end) {
            this.end = end;
            return this;
        }

        public SyncOrdersBuilder start(String start) {
            this.start = start;
            return this;
        }

        public SyncOrders build() {
            return new SyncOrders(this.nextEvaluatedKey, this.end, this.start);
        }

        public String toString() {
            return "SyncOrders.SyncOrdersBuilder(nextEvaluatedKey=" + this.nextEvaluatedKey + ", end=" + this.end + ", start=" + this.start + ")";
        }
    }
}

