/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.order;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.OrderCreate;
import net.accelbyte.sdk.api.platform.models.OrderInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicCreateUserOrder
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/orders";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private OrderCreate body;

    @Deprecated
    public PublicCreateUserOrder(String namespace, String userId, OrderCreate body) {
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public OrderCreate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public OrderInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 201) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OrderInfo().createFromJson(json);
    }

    public static PublicCreateUserOrderBuilder builder() {
        return new PublicCreateUserOrderBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public OrderCreate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(OrderCreate body) {
        this.body = body;
    }

    public static class PublicCreateUserOrderBuilder {
        private String namespace;
        private String userId;
        private OrderCreate body;

        PublicCreateUserOrderBuilder() {
        }

        public PublicCreateUserOrderBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicCreateUserOrderBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicCreateUserOrderBuilder body(OrderCreate body) {
            this.body = body;
            return this;
        }

        public PublicCreateUserOrder build() {
            return new PublicCreateUserOrder(this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "PublicCreateUserOrder.PublicCreateUserOrderBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

