/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.key_group;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.BulkOperationResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UploadKeys
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/keygroups/{keyGroupId}/keys";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("multipart/form-data");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String keyGroupId;
    private String namespace;
    private File file;

    @Deprecated
    public UploadKeys(String keyGroupId, String namespace, File file) {
        this.keyGroupId = keyGroupId;
        this.namespace = namespace;
        this.file = file;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.keyGroupId != null) {
            pathParams.put("keyGroupId", this.keyGroupId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.file != null) {
            formDataParams.put("file", this.file);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.keyGroupId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public BulkOperationResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new BulkOperationResult().createFromJson(json);
    }

    public static UploadKeysBuilder builder() {
        return new UploadKeysBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getKeyGroupId() {
        return this.keyGroupId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public File getFile() {
        return this.file;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setKeyGroupId(String keyGroupId) {
        this.keyGroupId = keyGroupId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static class UploadKeysBuilder {
        private String keyGroupId;
        private String namespace;
        private File file;

        UploadKeysBuilder() {
        }

        public UploadKeysBuilder keyGroupId(String keyGroupId) {
            this.keyGroupId = keyGroupId;
            return this;
        }

        public UploadKeysBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UploadKeysBuilder file(File file) {
            this.file = file;
            return this;
        }

        public UploadKeys build() {
            return new UploadKeys(this.keyGroupId, this.namespace, this.file);
        }

        public String toString() {
            return "UploadKeys.UploadKeysBuilder(keyGroupId=" + this.keyGroupId + ", namespace=" + this.namespace + ", file=" + this.file + ")";
        }
    }
}

