/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.key_group;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.KeyGroupPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryKeyGroups
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/keygroups";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Integer limit;
    private String name;
    private Integer offset;
    private String tag;

    @Deprecated
    public QueryKeyGroups(String namespace, Integer limit, String name, Integer offset, String tag) {
        this.namespace = namespace;
        this.limit = limit;
        this.name = name;
        this.offset = offset;
        this.tag = tag;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("name", this.name == null ? null : Arrays.asList(this.name));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("tag", this.tag == null ? null : Arrays.asList(this.tag));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public KeyGroupPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new KeyGroupPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("name", "None");
        result.put("offset", "None");
        result.put("tag", "None");
        return result;
    }

    public static QueryKeyGroupsBuilder builder() {
        return new QueryKeyGroupsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getTag() {
        return this.tag;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public static class QueryKeyGroupsBuilder {
        private String namespace;
        private Integer limit;
        private String name;
        private Integer offset;
        private String tag;

        QueryKeyGroupsBuilder() {
        }

        public QueryKeyGroupsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryKeyGroupsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryKeyGroupsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public QueryKeyGroupsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryKeyGroupsBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public QueryKeyGroups build() {
            return new QueryKeyGroups(this.namespace, this.limit, this.name, this.offset, this.tag);
        }

        public String toString() {
            return "QueryKeyGroups.QueryKeyGroupsBuilder(namespace=" + this.namespace + ", limit=" + this.limit + ", name=" + this.name + ", offset=" + this.offset + ", tag=" + this.tag + ")";
        }
    }
}

