/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ItemTypeConfigInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class SearchItemTypeConfig
extends Operation {
    private String path = "/platform/admin/items/configs/search";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String clazz;
    private String itemType;

    @Deprecated
    public SearchItemTypeConfig(String clazz, String itemType) {
        this.clazz = clazz;
        this.itemType = itemType;
        this.securities.add("Bearer");
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("clazz", this.clazz == null ? null : Arrays.asList(this.clazz));
        queryParams.put("itemType", this.itemType == null ? null : Arrays.asList(this.itemType));
        return queryParams;
    }

    public boolean isValid() {
        return this.itemType != null;
    }

    public ItemTypeConfigInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ItemTypeConfigInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("clazz", "None");
        result.put("itemType", "None");
        return result;
    }

    public static SearchItemTypeConfigBuilder builder() {
        return new SearchItemTypeConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public static class SearchItemTypeConfigBuilder {
        private String clazz;
        private String itemType;

        public SearchItemTypeConfigBuilder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public SearchItemTypeConfigBuilder itemTypeFromEnum(ItemType itemType) {
            this.itemType = itemType.toString();
            return this;
        }

        SearchItemTypeConfigBuilder() {
        }

        public SearchItemTypeConfigBuilder clazz(String clazz) {
            this.clazz = clazz;
            return this;
        }

        public SearchItemTypeConfig build() {
            return new SearchItemTypeConfig(this.clazz, this.itemType);
        }

        public String toString() {
            return "SearchItemTypeConfig.SearchItemTypeConfigBuilder(clazz=" + this.clazz + ", itemType=" + this.itemType + ")";
        }
    }

    public static enum ItemType {
        APP("APP"),
        BUNDLE("BUNDLE"),
        CODE("CODE"),
        COINS("COINS"),
        EXTENSION("EXTENSION"),
        INGAMEITEM("INGAMEITEM"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SEASON("SEASON"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private ItemType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

