/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ItemReturnRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ReturnItem
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/items/{itemId}/return";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String itemId;
    private String namespace;
    private ItemReturnRequest body;

    @Deprecated
    public ReturnItem(String itemId, String namespace, ItemReturnRequest body) {
        this.itemId = itemId;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.itemId != null) {
            pathParams.put("itemId", this.itemId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ItemReturnRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.itemId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static ReturnItemBuilder builder() {
        return new ReturnItemBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ItemReturnRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ItemReturnRequest body) {
        this.body = body;
    }

    public static class ReturnItemBuilder {
        private String itemId;
        private String namespace;
        private ItemReturnRequest body;

        ReturnItemBuilder() {
        }

        public ReturnItemBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public ReturnItemBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ReturnItemBuilder body(ItemReturnRequest body) {
            this.body = body;
            return this;
        }

        public ReturnItem build() {
            return new ReturnItem(this.itemId, this.namespace, this.body);
        }

        public String toString() {
            return "ReturnItem.ReturnItemBuilder(itemId=" + this.itemId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

