/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.FullItemPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryUncategorizedItems
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/items/uncategorized";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean activeOnly;
    private Integer limit;
    private Integer offset;
    private List<String> sortBy;
    private String storeId;

    @Deprecated
    public QueryUncategorizedItems(String namespace, Boolean activeOnly, Integer limit, Integer offset, List<String> sortBy, String storeId) {
        this.namespace = namespace;
        this.activeOnly = activeOnly;
        this.limit = limit;
        this.offset = offset;
        this.sortBy = sortBy;
        this.storeId = storeId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("activeOnly", this.activeOnly == null ? null : Arrays.asList(String.valueOf(this.activeOnly)));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sortBy", this.sortBy == null ? null : this.sortBy);
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public FullItemPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new FullItemPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activeOnly", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("sortBy", "csv");
        result.put("storeId", "None");
        return result;
    }

    public static QueryUncategorizedItemsBuilder builder() {
        return new QueryUncategorizedItemsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public List<String> getSortBy() {
        return this.sortBy;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActiveOnly(Boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public static class QueryUncategorizedItemsBuilder {
        private String namespace;
        private Boolean activeOnly;
        private Integer limit;
        private Integer offset;
        private String storeId;
        private List<String> sortBy;

        public QueryUncategorizedItemsBuilder sortBy(List<String> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public QueryUncategorizedItemsBuilder sortByFromEnum(List<SortBy> sortBy) {
            ArrayList<String> en = new ArrayList<String>();
            for (SortBy e : sortBy) {
                en.add(e.toString());
            }
            this.sortBy = en;
            return this;
        }

        QueryUncategorizedItemsBuilder() {
        }

        public QueryUncategorizedItemsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryUncategorizedItemsBuilder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public QueryUncategorizedItemsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryUncategorizedItemsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryUncategorizedItemsBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public QueryUncategorizedItems build() {
            return new QueryUncategorizedItems(this.namespace, this.activeOnly, this.limit, this.offset, this.sortBy, this.storeId);
        }

        public String toString() {
            return "QueryUncategorizedItems.QueryUncategorizedItemsBuilder(namespace=" + this.namespace + ", activeOnly=" + this.activeOnly + ", limit=" + this.limit + ", offset=" + this.offset + ", sortBy=" + this.sortBy + ", storeId=" + this.storeId + ")";
        }
    }

    public static enum SortBy {
        Name("name"),
        Nameasc("name:asc"),
        Namedesc("name:desc"),
        CreatedAt("createdAt"),
        CreatedAtasc("createdAt:asc"),
        CreatedAtdesc("createdAt:desc"),
        UpdatedAt("updatedAt"),
        UpdatedAtasc("updatedAt:asc"),
        UpdatedAtdesc("updatedAt:desc"),
        DisplayOrder("displayOrder"),
        DisplayOrderasc("displayOrder:asc"),
        DisplayOrderdesc("displayOrder:desc");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

