/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ItemPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicSearchItems
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/items/search";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String itemType;
    private Integer limit;
    private Integer offset;
    private String region;
    private String storeId;
    private String keyword;
    private String language;

    @Deprecated
    public PublicSearchItems(String namespace, String itemType, Integer limit, Integer offset, String region, String storeId, String keyword, String language) {
        this.namespace = namespace;
        this.itemType = itemType;
        this.limit = limit;
        this.offset = offset;
        this.region = region;
        this.storeId = storeId;
        this.keyword = keyword;
        this.language = language;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("itemType", this.itemType == null ? null : Arrays.asList(this.itemType));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("keyword", this.keyword == null ? null : Arrays.asList(this.keyword));
        queryParams.put("language", this.language == null ? null : Arrays.asList(this.language));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.keyword == null) {
            return false;
        }
        return this.language != null;
    }

    public ItemPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ItemPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("itemType", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("region", "None");
        result.put("storeId", "None");
        result.put("keyword", "None");
        result.put("language", "None");
        return result;
    }

    public static PublicSearchItemsBuilder builder() {
        return new PublicSearchItemsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getItemType() {
        return this.itemType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getRegion() {
        return this.region;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public static class PublicSearchItemsBuilder {
        private String namespace;
        private Integer limit;
        private Integer offset;
        private String region;
        private String storeId;
        private String keyword;
        private String language;
        private String itemType;

        public PublicSearchItemsBuilder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public PublicSearchItemsBuilder itemTypeFromEnum(ItemType itemType) {
            this.itemType = itemType.toString();
            return this;
        }

        PublicSearchItemsBuilder() {
        }

        public PublicSearchItemsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicSearchItemsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicSearchItemsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicSearchItemsBuilder region(String region) {
            this.region = region;
            return this;
        }

        public PublicSearchItemsBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public PublicSearchItemsBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public PublicSearchItemsBuilder language(String language) {
            this.language = language;
            return this;
        }

        public PublicSearchItems build() {
            return new PublicSearchItems(this.namespace, this.itemType, this.limit, this.offset, this.region, this.storeId, this.keyword, this.language);
        }

        public String toString() {
            return "PublicSearchItems.PublicSearchItemsBuilder(namespace=" + this.namespace + ", itemType=" + this.itemType + ", limit=" + this.limit + ", offset=" + this.offset + ", region=" + this.region + ", storeId=" + this.storeId + ", keyword=" + this.keyword + ", language=" + this.language + ")";
        }
    }

    public static enum ItemType {
        APP("APP"),
        BUNDLE("BUNDLE"),
        CODE("CODE"),
        COINS("COINS"),
        EXTENSION("EXTENSION"),
        INGAMEITEM("INGAMEITEM"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SEASON("SEASON"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private ItemType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

