/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ItemDynamicDataInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetItemDynamicData
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/items/{itemId}/dynamic";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String itemId;
    private String namespace;

    @Deprecated
    public PublicGetItemDynamicData(String itemId, String namespace) {
        this.itemId = itemId;
        this.namespace = namespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.itemId != null) {
            pathParams.put("itemId", this.itemId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.itemId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ItemDynamicDataInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ItemDynamicDataInfo().createFromJson(json);
    }

    public static PublicGetItemDynamicDataBuilder builder() {
        return new PublicGetItemDynamicDataBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class PublicGetItemDynamicDataBuilder {
        private String itemId;
        private String namespace;

        PublicGetItemDynamicDataBuilder() {
        }

        public PublicGetItemDynamicDataBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public PublicGetItemDynamicDataBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetItemDynamicData build() {
            return new PublicGetItemDynamicData(this.itemId, this.namespace);
        }

        public String toString() {
            return "PublicGetItemDynamicData.PublicGetItemDynamicDataBuilder(itemId=" + this.itemId + ", namespace=" + this.namespace + ")";
        }
    }
}

