/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ItemInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetItemBySku
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/items/bySku";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String language;
    private String region;
    private String storeId;
    private String sku;

    @Deprecated
    public PublicGetItemBySku(String namespace, String language, String region, String storeId, String sku) {
        this.namespace = namespace;
        this.language = language;
        this.region = region;
        this.storeId = storeId;
        this.sku = sku;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("language", this.language == null ? null : Arrays.asList(this.language));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("sku", this.sku == null ? null : Arrays.asList(this.sku));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.sku != null;
    }

    public ItemInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ItemInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("language", "None");
        result.put("region", "None");
        result.put("storeId", "None");
        result.put("sku", "None");
        return result;
    }

    public static PublicGetItemBySkuBuilder builder() {
        return new PublicGetItemBySkuBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getRegion() {
        return this.region;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getSku() {
        return this.sku;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public static class PublicGetItemBySkuBuilder {
        private String namespace;
        private String language;
        private String region;
        private String storeId;
        private String sku;

        PublicGetItemBySkuBuilder() {
        }

        public PublicGetItemBySkuBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetItemBySkuBuilder language(String language) {
            this.language = language;
            return this;
        }

        public PublicGetItemBySkuBuilder region(String region) {
            this.region = region;
            return this;
        }

        public PublicGetItemBySkuBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public PublicGetItemBySkuBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public PublicGetItemBySku build() {
            return new PublicGetItemBySku(this.namespace, this.language, this.region, this.storeId, this.sku);
        }

        public String toString() {
            return "PublicGetItemBySku.PublicGetItemBySkuBuilder(namespace=" + this.namespace + ", language=" + this.language + ", region=" + this.region + ", storeId=" + this.storeId + ", sku=" + this.sku + ")";
        }
    }
}

