/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.BasicItem;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ListBasicItemsByFeatures
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/items/byFeatures/basic";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean activeOnly;
    private List<String> features;

    @Deprecated
    public ListBasicItemsByFeatures(String namespace, Boolean activeOnly, List<String> features) {
        this.namespace = namespace;
        this.activeOnly = activeOnly;
        this.features = features;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("activeOnly", this.activeOnly == null ? null : Arrays.asList(String.valueOf(this.activeOnly)));
        queryParams.put("features", this.features == null ? null : this.features);
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public List<BasicItem> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<BasicItem>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activeOnly", "None");
        result.put("features", "multi");
        return result;
    }

    public static ListBasicItemsByFeaturesBuilder builder() {
        return new ListBasicItemsByFeaturesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActiveOnly(Boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public static class ListBasicItemsByFeaturesBuilder {
        private String namespace;
        private Boolean activeOnly;
        private List<String> features;

        ListBasicItemsByFeaturesBuilder() {
        }

        public ListBasicItemsByFeaturesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ListBasicItemsByFeaturesBuilder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public ListBasicItemsByFeaturesBuilder features(List<String> features) {
            this.features = features;
            return this;
        }

        public ListBasicItemsByFeatures build() {
            return new ListBasicItemsByFeatures(this.namespace, this.activeOnly, this.features);
        }

        public String toString() {
            return "ListBasicItemsByFeatures.ListBasicItemsByFeaturesBuilder(namespace=" + this.namespace + ", activeOnly=" + this.activeOnly + ", features=" + this.features + ")";
        }
    }
}

