/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ItemId;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetItemIdBySku
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/items/itemId/bySku";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean activeOnly;
    private String storeId;
    private String sku;

    @Deprecated
    public GetItemIdBySku(String namespace, Boolean activeOnly, String storeId, String sku) {
        this.namespace = namespace;
        this.activeOnly = activeOnly;
        this.storeId = storeId;
        this.sku = sku;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("activeOnly", this.activeOnly == null ? null : Arrays.asList(String.valueOf(this.activeOnly)));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("sku", this.sku == null ? null : Arrays.asList(this.sku));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.sku != null;
    }

    public ItemId parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ItemId().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activeOnly", "None");
        result.put("storeId", "None");
        result.put("sku", "None");
        return result;
    }

    public static GetItemIdBySkuBuilder builder() {
        return new GetItemIdBySkuBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getSku() {
        return this.sku;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActiveOnly(Boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public static class GetItemIdBySkuBuilder {
        private String namespace;
        private Boolean activeOnly;
        private String storeId;
        private String sku;

        GetItemIdBySkuBuilder() {
        }

        public GetItemIdBySkuBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetItemIdBySkuBuilder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public GetItemIdBySkuBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public GetItemIdBySkuBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public GetItemIdBySku build() {
            return new GetItemIdBySku(this.namespace, this.activeOnly, this.storeId, this.sku);
        }

        public String toString() {
            return "GetItemIdBySku.GetItemIdBySkuBuilder(namespace=" + this.namespace + ", activeOnly=" + this.activeOnly + ", storeId=" + this.storeId + ", sku=" + this.sku + ")";
        }
    }
}

